% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/payoffs_list.R
\name{payoffs_list}
\alias{payoffs_list}
\title{Compute Payoff Values for Quantum HIV Phenotype Interactions}
\usage{
payoffs_list(gates, alpha, beta, gamma, theta, alpha2, beta2, gamma2, theta2)
}
\arguments{
\item{gates}{A named list of 2x2 unitary matrices representing quantum strategies (e.g., I, H, Z).}

\item{alpha}{Numeric scalar, payoff coefficient for phenotype \code{v} when both play \code{0}.}

\item{beta}{Numeric scalar, payoff coefficient for phenotype \code{v} when \code{v} plays \code{0}, \code{V} plays \code{1}.}

\item{gamma}{Numeric scalar, payoff coefficient for phenotype \code{v} when \code{v} plays \code{1}, \code{V} plays \code{0}.}

\item{theta}{Numeric scalar, payoff coefficient for phenotype \code{v} and \code{V} when both play \code{1}.}

\item{alpha2}{Numeric scalar, alternate value of \code{alpha} for phenotype \code{v} in a second scenario.}

\item{beta2}{Numeric scalar, alternate value of \code{beta} for phenotype \code{v} in a second scenario.}

\item{gamma2}{Numeric scalar, alternate value of \code{gamma} for phenotype \code{v} in a second scenario.}

\item{theta2}{Numeric scalar, alternate value of \code{theta} for phenotype \code{v} in a second scenario.}
}
\description{
Computes payoff values for all pairwise combinations of quantum gate strategies provided in
a named list. For each pair, the function calculates the payoffs for both phenotypes \code{v} and \code{V}
using two different sets of payoff parameters.
}
\examples{
I <- diag(2)
H <- 1 / sqrt(2) * matrix(c(1, 1, 1, -1), 2, 2)
Z <- diag(c(1, -1))
gates <- list(I = I, H = H, Z = Z)
payoffs <- payoffs_list(gates, 1, 0.5, 0.3,0.2, 1.5, 0.6, 0.7, 0.8)
}
