/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jpmml.rexp.Converter;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RStringVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterFactory {
    private static Map<String, Class<? extends Converter<?>>> converters = new LinkedHashMap();
    private static final Logger logger = LoggerFactory.getLogger(ConverterFactory.class);

    protected ConverterFactory() {
    }

    public <R extends RExp> Converter<R> newConverter(R rexp) {
        RStringVector classNames = rexp._class();
        for (String className : classNames) {
            Class<? extends Converter<?>> clazz = converters.get(className);
            if (clazz == null) continue;
            return this.newConverter(clazz, rexp);
        }
        throw new IllegalArgumentException("No built-in converter for class " + classNames.getValues());
    }

    public <R extends RExp> Converter<R> newConverter(Class<? extends Converter<?>> clazz, R rexp) {
        try {
            Class<?> rexpClazz = rexp.getClass();
            while (rexpClazz.isAnonymousClass()) {
                rexpClazz = rexpClazz.getSuperclass();
            }
            Constructor<Converter<?>> constructor = clazz.getDeclaredConstructor(rexpClazz);
            return constructor.newInstance(rexp);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ConverterFactory newInstance() {
        return new ConverterFactory();
    }

    private static void init(ClassLoader classLoader) {
        Enumeration<URL> urls;
        try {
            urls = classLoader.getResources("META-INF/r2pmml.properties");
        }
        catch (IOException ioe) {
            logger.warn("Failed to find resources", (Throwable)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            logger.trace("Loading resource " + url);
            try {
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    Properties properties = new Properties();
                    properties.load(is);
                    ConverterFactory.init(classLoader, properties);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException ioe) {
                logger.warn("Failed to load resource", (Throwable)ioe);
            }
        }
    }

    private static void init(ClassLoader classLoader, Properties properties) {
        if (properties.isEmpty()) {
            return;
        }
        Set<String> keys = properties.stringPropertyNames();
        for (String key : keys) {
            Class<?> converterClazz;
            String value = properties.getProperty(key);
            logger.trace("Mapping R class " + key + " to converter class " + value);
            try {
                converterClazz = classLoader.loadClass(value);
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn("Failed to load converter class", (Throwable)cnfe);
                continue;
            }
            if (!Converter.class.isAssignableFrom(converterClazz)) {
                throw new IllegalArgumentException("Converter class " + converterClazz.getName() + " is not a subclass of " + Converter.class.getName());
            }
            converters.put(key, converterClazz);
        }
    }

    static {
        ClassLoader clazzLoader = ConverterFactory.class.getClassLoader();
        ConverterFactory.init(clazzLoader);
    }
}

