% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neutron_geom_cf.R
\name{neutron_geom_cf}
\alias{neutron_geom_cf}
\title{Solid Angle Correction for Neutron Detectors with Point Source}
\usage{
neutron_geom_cf(l, r.d, del = 0.5)
}
\arguments{
\item{l}{The distance from the center of the detector to the center of the
source. Units of l and r.d must be consistent.}

\item{r.d}{The detector radius. Value for typical NRD is 11 cm. An example is
also provided with a Rem 500 detector with a radius of 4.5 cm.}

\item{del}{The neutron effectiveness factor, default per ISO.}
}
\value{
The correction factor for solid angle.
}
\description{
Correction factors are needed when an Neutron Rem Detector (NRD)
aka "Remball" is used in close proximity to a points source. This formula
is per ISO ISO 8529-2-2000 section 6.2. Note, however, that the ISO formula
predicts the response. The formula used here takes the inverse to correct
for the over-response.
}
\examples{
neutron_geom_cf(l = 11.1, r.d = 11)
neutron_geom_cf(30, 11)
neutron_geom_cf(5, 4.5)
}
\seealso{
Other rad measurements: 
\code{\link{air_dens_cf}()},
\code{\link{disk_to_disk_solid_angle}()},
\code{\link{scaler_sim}()},
\code{\link{tau_estimate}()}
}
\concept{rad measurements}
