% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrd_sens_cutoff.R
\name{mrd_sens_cutoff}
\alias{mrd_sens_cutoff}
\title{Cutoff Sensitivity Simulation for Multivariate Regression Discontinuity}
\usage{
mrd_sens_cutoff(object, cutoffs)
}
\arguments{
\item{object}{An object returned by \code{mrd_est} or \code{mrd_impute}.}

\item{cutoffs}{A two-column numeric matrix of paired cutoff values 
to be used for refitting an \code{mrd} object.}
}
\value{
A dataframe which contains the estimate \code{est} and standard error \code{se} 
  for each pairs of cutoffs (\code{A1} and \code{A2}). \code{A1} contains varying cutoffs 
  on assignment 1, and \code{A2} assignment 2.
}
\description{
\code{mrd_sens_cutoff} refits the supplemented model with varying cutoff(s). 
Other estimation parameters, such as the automatically calculated bandwidth, are held constant.
}
\examples{
x1 <- runif(1000, -1, 1)
x2 <- rnorm(1000, 10, 2)
cov <- rnorm(1000)
y <- 3 + 2 * x1 + 1 * x2 + 3 * cov + 10 * (x1 >= 0) + 5 * (x2 >= 10) + rnorm(1000)
mrd <- mrd_est(y ~ x1 + x2 | cov, cutpoint = c(0, 10), t.design = c("geq", "geq"))
mrd_sens_cutoff(mrd, expand.grid(A1 = seq(-.5, .5, length.out = 5), A2 = 10))
}
