% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rd.R
\name{summary.rd}
\alias{summary.rd}
\title{Summarize the Regression Discontinuity}
\usage{
\method{summary}{rd}(object, level = 0.95, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{An object of class \code{"rd"}, usually a result of a call to \code{\link{rd_est}}.}

\item{level}{A numeric value between 0 and 1 specifying the confidence level for confidence intervals. The default is 0.95.}

\item{digits}{A non-negative integer specifying the number of digits to display.
The default is \code{max(3, getOption("digits") - 3)}.}

\item{...}{Additional arguments passed to \code{summary}..}
}
\value{
\code{summary.rd} returns a list which has the following components:
\item{coefficients}{A matrix containing bandwidths, number of observations, estimates, 
  SEs, confidence intervals, z-values and p-values for each estimated bandwidth.}
}
\description{
\code{summary.rd} is a \code{summary} method for class \code{"rd"}
It is based on \code{summary.RD} function in the "rdd" package.
}
\references{
Drew Dimmery (2016). rdd: Regression Discontinuity Estimation. R package
   version 0.57. https://CRAN.R-project.org/package=rdd
}
