% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_help.R
\name{cran_help_cliques}
\alias{cran_help_cliques}
\title{Help pages with cliques}
\usage{
cran_help_cliques(packages = NULL)
}
\arguments{
\item{packages}{A vector with packages or \code{NULL} for all packages.}
}
\value{
Return a data.frame of help pages not connected to the network of help pages.
Or NULL if nothing are found.
}
\description{
Some help pages have links to other pages and they might be linked from others
but they are closed network: there is no link that leads to different help pages.
}
\details{
Requires igraph
}
\examples{
\dontshow{if (requireNamespace("igraph", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chc <- cran_help_cliques("BaseSet")
head(chc)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions related to CRAN help pages: 
\code{\link{cran_help_pages_not_linked}()},
\code{\link{cran_help_pages_wo_links}()}
}
\concept{functions related to CRAN help pages}
