% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cite_easystats.R
\name{cite_easystats}
\alias{cite_easystats}
\alias{summary.cite_easystats}
\alias{print.cite_easystats}
\title{Cite the easystats ecosystem}
\usage{
cite_easystats(
  packages = "easystats",
  format = c("text", "markdown", "biblatex"),
  intext_prefix = TRUE,
  intext_suffix = "."
)

\method{summary}{cite_easystats}(object, what = "all", ...)

\method{print}{cite_easystats}(x, what = "all", ...)
}
\arguments{
\item{packages}{A character vector of packages to cite. Can be \code{"all"} for
all \emph{easystats} packages or a vector with specific package names.}

\item{format}{The format to generate citations. Can be \code{"text"} for plain
text, \code{"markdown"} for markdown citations and CSL bibliography
(recommended for writing in RMarkdown), or \code{"biblatex"} for BibLaTeX
citations and bibliography.}

\item{intext_prefix}{A character vector of length 1 containing text to
include before in-text citations. If \code{TRUE}, defaults to \code{"Analyses were conducted using the easystats collection of packages "}. If \code{FALSE} or
\code{NA}, no prefix is included.}

\item{intext_suffix}{A character vector of length 1 containing text to
include after in-text citations. Defaults to \code{"."}. If \code{FALSE} or \code{NA},
no suffix is included.}

\item{what}{What elements of the citations to print, can be \code{"all"},
\code{"intext"}, or \code{"refs"}.}

\item{...}{Not used. Included for compatibility with the generic function.}

\item{x, object}{A \code{"cite_easystats"} object to print.}
}
\value{
A list of class \code{"cite_easystats"} with elements:
\itemize{
\item \code{intext}: In-text citations in the requested \code{format}
\item \code{refs}: References or bibliography in the requested \code{format}
}
}
\description{
A convenient function for those who wish to cite the easystats packages.
}
\examples{
\donttest{
# Cite just the 'easystats' umbrella package:
cite_easystats()
summary(cite_easystats(), what = "all")

# Cite every easystats package:
cite_easystats(packages = "all")
summary(cite_easystats(packages = "all"), what = "all")

# Cite specific packages:
cite_easystats(packages = c("modelbased", "see"))
summary(cite_easystats(packages = c("modelbased", "see")), what = "all")

# To cite easystats packages in an RMarkdown document, use:

## In-text citations:
print(cite_easystats(format = "markdown"), what = "intext")

## Bibliography (print with the  `output = 'asis'` option on the code chunk)
print(cite_easystats(format = "markdown"), what = "refs")
}

}
