% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lblCode.R
\name{set_labels}
\alias{set_labels}
\title{Set variable labels}
\usage{
set_labels(data, names_labels)
}
\arguments{
\item{data}{data frame to be labelled}

\item{names_labels}{data frame with column 1 containing variable names from
data and column 2 containing variable labels. Other columns will be
ignored.}
}
\description{
Assign variable labels to a data.frame from a lookup table.
}
\details{
Useful if variable labels have been imported from a data dictionary. The
first column in names_labels must contain the variable name and the second
column the variable label. The column names are not used.

If no label is provided then the existing label will not be changed. To
remove a label set the label to NA.
}
\examples{
# create data frame with labels
lbls <- data.frame(c1=c('cohort','size_change'),
c2=c('Cancer cohort','Change in tumour size'))
# set labels and return labelled data frame
set_labels(ctDNA,lbls)
}
