/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.logger;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Logger {
    protected final List<PrintStream> pstreams = new ArrayList<PrintStream>();

    public Logger() {
        this.pstreams.add(System.out);
    }

    public Logger(Logger aLogger) {
        this.pstreams.addAll(aLogger.pstreams);
    }

    public final void add(PrintStream ps) {
        this.pstreams.add(ps);
    }

    public final void remove(PrintStream ps) {
        this.pstreams.remove(ps);
    }

    public Logger bold() {
        return this;
    }

    public Logger black() {
        return this;
    }

    public final void reset() {
        this.postfix();
    }

    public Logger white() {
        return this;
    }

    public Logger red() {
        return this;
    }

    public Logger green() {
        return this;
    }

    public Logger blue() {
        return this;
    }

    protected void prefix() {
    }

    protected void postfix() {
    }

    public final void print(String msg) {
        this.prefix();
        this.pstreams.forEach(p -> p.print(msg));
        this.postfix();
    }

    public final void println(String msg) {
        this.prefix();
        this.pstreams.forEach(p -> p.println(msg));
        this.postfix();
    }

    public final void printf(String format, Object ... args) {
        this.prefix();
        this.pstreams.forEach(p -> p.printf(format, args));
        this.postfix();
    }

    public final void printf(Locale l, String format, Object ... args) {
        this.prefix();
        this.pstreams.forEach(p -> p.printf(l, format, args));
        this.postfix();
    }
}

