/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class PropXinSReif
extends Propagator<IntVar> {
    IntVar var;
    IntIterableRangeSet set;
    BoolVar r;

    public PropXinSReif(IntVar x, IntIterableRangeSet set, BoolVar r) {
        super((Variable[])new IntVar[]{x, r}, (Priority)PropagatorPriority.BINARY, false, true);
        this.set = set;
        this.var = x;
        this.r = r;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.r.isInstantiated()) {
            if (this.r.getValue() == 1) {
                this.var.removeAllValuesBut(this.set, this);
                this.setPassive();
            } else if (this.var.removeValues(this.set, this) || !this.set.intersect(this.var)) {
                this.setPassive();
            }
        } else if (IntIterableSetUtils.includedIn(this.var, this.set)) {
            this.r.setToTrue(this);
            this.setPassive();
        } else if (!this.set.intersect(this.var)) {
            this.r.setToFalse(this);
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            if (this.r.isInstantiatedTo(1)) {
                return ESat.eval(IntIterableSetUtils.includedIn(this.var, this.set));
            }
            return ESat.eval(!this.set.intersect(this.var));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        if (((IntVar[])this.vars)[1].isInstantiatedTo(1)) {
            if (pivot == ((IntVar[])this.vars)[1]) {
                ((IntVar[])this.vars)[1].intersectLit(1, explanation);
                IntIterableRangeSet set0 = explanation.universe();
                set0.removeAll(this.set);
                ((IntVar[])this.vars)[0].unionLit(set0, explanation);
            } else if (pivot == ((IntVar[])this.vars)[0]) {
                ((IntVar[])this.vars)[1].unionLit(0, explanation);
                ((IntVar[])this.vars)[0].intersectLit(explanation.empty().copyFrom(this.set), explanation);
            }
        } else if (((IntVar[])this.vars)[1].isInstantiatedTo(0)) {
            if (pivot == ((IntVar[])this.vars)[1]) {
                ((IntVar[])this.vars)[1].intersectLit(0, explanation);
                ((IntVar[])this.vars)[0].unionLit(explanation.empty().copyFrom(this.set), explanation);
            } else if (pivot == ((IntVar[])this.vars)[0]) {
                ((IntVar[])this.vars)[1].unionLit(1, explanation);
                IntIterableRangeSet set0 = explanation.universe();
                set0.removeAll(this.set);
                ((IntVar[])this.vars)[0].intersectLit(set0, explanation);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public String toString() {
        return "(" + this.var.getName() + " \u2208 " + this.set + ") <=> " + this.r.getName();
    }
}

