% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{r.calib}
\alias{r.calib}
\title{return a random calendar age from a calibrated distribution}
\usage{
r.calib(
  n,
  y,
  er,
  cc = 1,
  postbomb = FALSE,
  deltaR = 0,
  deltaSTD = 0,
  as.F = FALSE,
  is.F = FALSE,
  thiscurve = NULL,
  yrsteps = FALSE,
  cc.resample = FALSE,
  dist.res = 200,
  threshold = 0,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  normalise = TRUE,
  BCAD = FALSE,
  rule = 2,
  cc.dir = NULL,
  seed = NA
)
}
\arguments{
\item{n}{The number of calendar ages to sample}

\item{y}{Uncalibrated radiocarbon age}

\item{er}{Lab error of the radiocarbon age}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages.}

\item{deltaR}{Age offset (e.g. for marine samples).}

\item{deltaSTD}{Uncertainty of the age offset (1 standard deviation).}

\item{as.F}{Whether or not to calculate ages in the F14C timescale. Defaults to \code{as.F=FALSE}, which uses the C14 timescale.}

\item{is.F}{Use this if the provided date is in the F14C timescale.}

\item{thiscurve}{As an alternative to providing cc and/or postbomb, the data of a specific curve can be provided (3 columns: cal BP, C14 age, error).}

\item{yrsteps}{Steps to use for interpolation. Defaults to the cal BP steps in the calibration curve}

\item{cc.resample}{The IntCal20 curves have different densities (every year between 0 and 5 kcal BP, then every 5 yr up to 15 kcal BP, then every 10 yr up to 25 kcal BP, and then every 20 yr up to 55 kcal BP). If calibrated ages span these density ranges, their drawn heights can differ, as can their total areas (which should ideally all sum to the same size). To account for this, resample to a constant time-span, using, e.g., \code{cc.resample=5} for 5-yr timespans.}

\item{dist.res}{As an alternative to yrsteps, provide the amount of 'bins' in the distribution}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=0}.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{normalise}{Sum the entire calibrated distribution to 1. Defaults to \code{normalise=TRUE}.}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{rule}{Which extrapolation rule to use. Defaults to \code{rule=1} which returns NAs.}

\item{cc.dir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{cc.dir="curves"}.}

\item{seed}{For reproducibility, a seed can be set (e.g., \code{seed=123}). Defaults to NA, no seed set.}
}
\value{
n randomly sampled calendar ages
}
\description{
Calculate the cumulative calibrated distribution, then sample n random uniform values between 0 and 1 and find the corresponding calendar ages through interpolation. Calendar ages with higher calibrated probabilities will be proportionally more likely to be sampled.
}
\examples{
  r.calib(10,130,20) # 10 random cal BP ages
  plot(density(r.calib(1e6, 2450, 20)))
}
\author{
Maarten Blaauw
}
