% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{BCADtob2k}
\alias{BCADtob2k}
\title{calculate b2k from cal BC/AD ages}
\usage{
BCADtob2k(x, zero = FALSE)
}
\arguments{
\item{x}{The BCAD age(s) to be translated into b2k age(s). BC ages are negative, AD ages are positive.}

\item{zero}{Whether or not zero BC/AD should be included. Defaults to \code{zero=FALSE}.}
}
\value{
The b2k age(s).
}
\description{
calculate b2k from cal BC/AD ages
}
\details{
Turn cal BC/AD (or BCE/CE) ages into b2k ages. b2k ages are used frequently in the ice core community. Negative ages indicate BC, positive ages AD. Since the Gregorian and Julian calendars do not include 0 BC/AD (i.e., 31 December of 1 BC is followed by 1 January of AD 1), zero can be omitted. The years then go from -1 (i.e., 1 BC) to 1 AD. Other calendars, such as the astronomical one, do include zero. The often-used BCE/CE ages are equivalent to BC/AD.
}
\examples{
 BCADtob2k(2025)
 BCADtob2k(-1, zero=TRUE)
 BCADtob2k(-1, zero=FALSE)
}
