/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.mainWindow;

import dmLab.gui.dataEditor.components.GlyphButton;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.mcfsEngine.MCFSAutoParams;
import dmLab.mcfs.mcfsEngine.MCFSExperiment;
import dmLab.utils.fileFilters.MyFileFilter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class MCFSPanel
extends JPanel
implements ActionListener {
    private JButton browseButton;
    private JTextField filePath;
    private JFileChooser fileDialog;
    private GlyphButton startButton;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField splits;
    private JTextField projections;
    private JTextField projectionSize;
    private JTextField balance;
    private JTextField threads;
    private JTextField splitSetSize;
    private JTextField cutoffPermutations;
    private MCFSParams mcfsParams = new MCFSParams();

    public MCFSPanel() {
        Object object = this.mcfsParams;
        ((MCFSParams)object).setDefault();
        object = this;
        ((Container)object).setLayout(null);
        ((MCFSPanel)object).browseButton = new JButton();
        ((MCFSPanel)object).browseButton.setBounds(10, 0, 180, 45);
        ((MCFSPanel)object).browseButton.setText("Browse");
        ((MCFSPanel)object).browseButton.setToolTipText("Select Input File");
        ((MCFSPanel)object).browseButton.setPreferredSize(new Dimension(70, 42));
        ((Container)object).add(((MCFSPanel)object).browseButton);
        ((MCFSPanel)object).filePath = new JTextField();
        ((MCFSPanel)object).filePath.setBounds(200, 10, 355, 25);
        ((MCFSPanel)object).filePath.setText("./data/AlizadehData.adx");
        ((MCFSPanel)object).filePath.setToolTipText("Path to Input File");
        ((MCFSPanel)object).filePath.setPreferredSize(new Dimension(238, 28));
        ((Container)object).add(((MCFSPanel)object).filePath);
        ((MCFSPanel)object).fileDialog = new JFileChooser();
        ((MCFSPanel)object).fileDialog.addChoosableFileFilter(new MyFileFilter("arff", "weka"));
        ((MCFSPanel)object).fileDialog.addChoosableFileFilter(new MyFileFilter("adx", "dmLab"));
        ((MCFSPanel)object).fileDialog.setCurrentDirectory(new File(".//data//"));
        ((MCFSPanel)object).jLabel1 = new JLabel();
        ((MCFSPanel)object).jLabel1.setBounds(10, 50, 150, 25);
        ((MCFSPanel)object).jLabel1.setText("projections (s):");
        ((MCFSPanel)object).jLabel1.setPreferredSize(new Dimension(70, 28));
        ((MCFSPanel)object).jLabel1.setFont(new Font("Dialog", 1, 12));
        ((Container)object).add(((MCFSPanel)object).jLabel1);
        ((MCFSPanel)object).projections = new JTextField();
        ((MCFSPanel)object).projections.setBounds(170, 50, 70, 25);
        ((MCFSPanel)object).projections.setText(MCFSAutoParams.valueToString(((MCFSPanel)object).mcfsParams.projections));
        ((MCFSPanel)object).projections.setPreferredSize(new Dimension(63, 21));
        ((MCFSPanel)object).projections.setToolTipText("in most cases a few thousands");
        ((Container)object).add(((MCFSPanel)object).projections);
        ((MCFSPanel)object).jLabel2 = new JLabel();
        ((MCFSPanel)object).jLabel2.setBounds(10, 80, 150, 25);
        ((MCFSPanel)object).jLabel2.setText("projection size (m):");
        ((MCFSPanel)object).jLabel2.setFont(new Font("Dialog", 1, 12));
        ((MCFSPanel)object).jLabel2.setPreferredSize(new Dimension(91, 28));
        ((Container)object).add(((MCFSPanel)object).jLabel2);
        ((MCFSPanel)object).projectionSize = new JTextField();
        ((MCFSPanel)object).projectionSize.setBounds(170, 80, 70, 25);
        ((MCFSPanel)object).projectionSize.setText(MCFSAutoParams.valueToString(((MCFSPanel)object).mcfsParams.projectionSize));
        ((MCFSPanel)object).projectionSize.setPreferredSize(new Dimension(63, 21));
        ((MCFSPanel)object).projectionSize.setToolTipText("<html>if <1 then fraction of original number of attributes is selected (e.g. 0.1 denotes 10% of input attributes)<br> if >1 then absolute number of randomly selected attributes</html>");
        ((Container)object).add(((MCFSPanel)object).projectionSize);
        ((MCFSPanel)object).jLabel3 = new JLabel();
        ((MCFSPanel)object).jLabel3.setBounds(10, 110, 150, 25);
        ((MCFSPanel)object).jLabel3.setText("splits (t):");
        ((MCFSPanel)object).jLabel3.setFont(new Font("Dialog", 1, 12));
        ((MCFSPanel)object).jLabel3.setPreferredSize(new Dimension(91, 28));
        ((Container)object).add(((MCFSPanel)object).jLabel3);
        ((MCFSPanel)object).splits = new JTextField();
        ((MCFSPanel)object).splits.setBounds(170, 110, 70, 25);
        ((MCFSPanel)object).splits.setText(Integer.toString(((MCFSPanel)object).mcfsParams.splits));
        ((MCFSPanel)object).splits.setPreferredSize(new Dimension(63, 21));
        ((MCFSPanel)object).splits.setToolTipText("in most cases it is small number (e.g. from 1-10)");
        ((Container)object).add(((MCFSPanel)object).splits);
        ((MCFSPanel)object).jLabel4 = new JLabel();
        ((MCFSPanel)object).jLabel4.setBounds(10, 140, 150, 25);
        ((MCFSPanel)object).jLabel4.setText("balance:");
        ((MCFSPanel)object).jLabel4.setFont(new Font("Dialog", 1, 12));
        ((MCFSPanel)object).jLabel4.setPreferredSize(new Dimension(91, 28));
        ((Container)object).add(((MCFSPanel)object).jLabel4);
        ((MCFSPanel)object).balance = new JTextField();
        ((MCFSPanel)object).balance.setBounds(170, 140, 70, 25);
        ((MCFSPanel)object).balance.setText(Float.toString(((MCFSPanel)object).mcfsParams.splitRatio));
        ((MCFSPanel)object).balance.setText(MCFSAutoParams.valueToString(((MCFSPanel)object).mcfsParams.balance));
        ((MCFSPanel)object).balance.setPreferredSize(new Dimension(63, 21));
        ((MCFSPanel)object).balance.setToolTipText("for highly imbalanced data set it on 2 or higher");
        ((Container)object).add(((MCFSPanel)object).balance);
        ((MCFSPanel)object).jLabel6 = new JLabel();
        ((MCFSPanel)object).jLabel6.setBounds(10, 170, 150, 25);
        ((MCFSPanel)object).jLabel6.setText("cutoff permutations:");
        ((MCFSPanel)object).jLabel6.setFont(new Font("Dialog", 1, 12));
        ((MCFSPanel)object).jLabel6.setPreferredSize(new Dimension(77, 16));
        ((Container)object).add(((MCFSPanel)object).jLabel6);
        ((MCFSPanel)object).cutoffPermutations = new JTextField();
        ((MCFSPanel)object).cutoffPermutations.setBounds(170, 170, 70, 25);
        ((MCFSPanel)object).cutoffPermutations.setText(Integer.toString(((MCFSPanel)object).mcfsParams.cutoffPermutations));
        ((MCFSPanel)object).cutoffPermutations.setPreferredSize(new Dimension(63, 20));
        ((MCFSPanel)object).cutoffPermutations.setToolTipText("number of permutations experiments minimum suggested value is 20");
        ((Container)object).add(((MCFSPanel)object).cutoffPermutations);
        ((MCFSPanel)object).jPanel1 = new JPanel();
        ((MCFSPanel)object).jPanel1.setBounds(250, 50, 300, 50);
        ((MCFSPanel)object).jPanel1.setLayout(null);
        ((MCFSPanel)object).jPanel1.setPreferredSize(new Dimension(156, 55));
        ((MCFSPanel)object).jPanel1.setBorder(BorderFactory.createEtchedBorder(1));
        ((Container)object).add(((MCFSPanel)object).jPanel1);
        ((MCFSPanel)object).jLabel5 = new JLabel();
        ((MCFSPanel)object).jLabel5.setBounds(10, 10, 150, 25);
        ((MCFSPanel)object).jLabel5.setText("Threads:");
        ((MCFSPanel)object).jLabel5.setFont(new Font("Dialog", 1, 12));
        ((MCFSPanel)object).jLabel5.setPreferredSize(new Dimension(80, 16));
        ((MCFSPanel)object).jPanel1.add(((MCFSPanel)object).jLabel5);
        ((MCFSPanel)object).threads = new JTextField();
        ((MCFSPanel)object).threads.setBounds(170, 10, 70, 25);
        ((MCFSPanel)object).threads.setText(Integer.toString(((MCFSPanel)object).mcfsParams.threadsNumber));
        ((MCFSPanel)object).threads.setPreferredSize(new Dimension(37, 16));
        ((MCFSPanel)object).jPanel1.add(((MCFSPanel)object).threads);
        ((MCFSPanel)object).jPanel2 = new JPanel();
        ((MCFSPanel)object).jPanel2.setBounds(250, 110, 300, 50);
        ((MCFSPanel)object).jPanel2.setLayout(null);
        ((MCFSPanel)object).jPanel2.setPreferredSize(new Dimension(156, 50));
        ((MCFSPanel)object).jPanel2.setBorder(BorderFactory.createEtchedBorder(1));
        ((Container)object).add(((MCFSPanel)object).jPanel2);
        ((MCFSPanel)object).jLabel7 = new JLabel();
        ((MCFSPanel)object).jLabel7.setBounds(10, 10, 150, 25);
        ((MCFSPanel)object).jLabel7.setText("split set - size:");
        ((MCFSPanel)object).jLabel7.setFont(new Font("Dialog", 1, 12));
        ((MCFSPanel)object).jLabel7.setPreferredSize(new Dimension(76, 15));
        ((MCFSPanel)object).jPanel2.add(((MCFSPanel)object).jLabel7);
        ((MCFSPanel)object).splitSetSize = new JTextField();
        ((MCFSPanel)object).splitSetSize.setBounds(170, 10, 70, 25);
        ((MCFSPanel)object).splitSetSize.setText(Integer.toString(((MCFSPanel)object).mcfsParams.splitSetSize));
        ((MCFSPanel)object).splitSetSize.setPreferredSize(new Dimension(35, 21));
        ((MCFSPanel)object).jPanel2.add(((MCFSPanel)object).splitSetSize);
        ((MCFSPanel)object).startButton = new GlyphButton("images/start.jpg", "Run MCFS");
        ((MCFSPanel)object).startButton.setBounds(400, 170, 150, 100);
        ((MCFSPanel)object).startButton.setToolTipText("Start MCFS Processing");
        ((MCFSPanel)object).startButton.setPreferredSize(new Dimension(105, 53));
        ((Container)object).add(((MCFSPanel)object).startButton);
        ((MCFSPanel)object).startButton.addActionListener((ActionListener)object);
        ((MCFSPanel)object).browseButton.addActionListener((ActionListener)object);
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        Object object;
        Object eventObject = event.getSource();
        if (eventObject == this.browseButton) {
            eventObject = this;
            if (((MCFSPanel)eventObject).fileDialog.showOpenDialog((Component)eventObject) == 0) {
                File file = ((MCFSPanel)eventObject).fileDialog.getSelectedFile();
                ((MCFSPanel)eventObject).filePath.setText(file.getAbsolutePath());
            }
            return;
        }
        if (object == this.startButton) {
            object = this;
            ((MCFSPanel)object).setMCFSParameters(((MCFSPanel)object).mcfsParams);
            ((MCFSPanel)object).mcfsParams.seed = System.currentTimeMillis();
            System.out.println(((MCFSPanel)object).mcfsParams.toString());
            MCFSExperiment mCFSExperiment = new MCFSExperiment(((MCFSPanel)object).mcfsParams);
            object = new Thread(mCFSExperiment);
            ((Thread)object).start();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean setMCFSParameters(MCFSParams mcfsParams) {
        void var2_2;
        File file = new File(this.filePath.getText());
        if (!file.exists()) {
            System.err.println("File: '" + this.filePath.getText() + "' does not exist.");
            return false;
        }
        mcfsParams.inputFilesPATH = file.getPath().substring(0, file.getPath().indexOf(file.getName()));
        mcfsParams.inputFiles = new String[]{file.getName()};
        mcfsParams.inputFileName = var2_2.getName();
        try {
            mcfsParams.projectionSize = MCFSAutoParams.valueToFloat("projectionSize", this.projectionSize.getText());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing projectionSize: " + this.projectionSize.getText());
            return false;
        }
        try {
            mcfsParams.projections = (int)MCFSAutoParams.valueToFloat("projections", this.projections.getText());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing projections: " + this.projections.getText());
            return false;
        }
        try {
            mcfsParams.splits = (int)Float.parseFloat(this.splits.getText());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing: " + this.splits.getText());
            return false;
        }
        try {
            mcfsParams.balance = MCFSAutoParams.valueToFloat("balance", this.balance.getText());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing balance: " + this.balance.getText());
            return false;
        }
        try {
            mcfsParams.threadsNumber = Integer.parseInt(this.threads.getText());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing threads: " + this.threads.getText());
            return false;
        }
        try {
            mcfsParams.splitSetSize = Integer.parseInt(this.splitSetSize.getText());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing splitSetSize: " + this.splitSetSize.getText());
            return false;
        }
        try {
            var1_1.cutoffPermutations = (int)Float.parseFloat(this.cutoffPermutations.getText());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error parsing: " + this.cutoffPermutations.getText());
            return false;
        }
        return true;
    }
}

