% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tik_get_advertiser_balance.R
\name{tik_get_advertiser_balance}
\alias{tik_get_advertiser_balance}
\title{Get the Balance and Budget of Ad Accounts}
\usage{
tik_get_advertiser_balance(bc_id, fields = NULL)
}
\arguments{
\item{bc_id}{Business Center ID.}

\item{fields}{A list of additional fields to return in the response. Supported values:
\itemize{
\item budget_remaining: The remaining budget.
\item budget_frequency_restriction: Restrictions on the number of budget changes allowed for the current day.
\item budget_amount_restriction: Restrictions on the minimum amount that can be changed for the budget.
\item min_transferable_amount: Details of the minimal amount that you can transfer to the ad account.
}}
}
\value{
tibble with balance and budget info
}
\description{
Use this endpoint to obtain the balance of ad accounts in the Business Center. You can also use this endpoint to obtain the budget of the ad accounts owned by the Business Center in auto-allocation mode.
}
\examples{
\dontrun{
bc <- tik_get_business_centers()
acs_balance <- tik_get_advertiser_balance(bc$bc_id)
}
}
