% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciReg.R
\name{ciReg}
\alias{ciReg}
\title{Confidence Intervals for Regression models}
\usage{
ciReg(fit, conf.level = 0.95, print.out = TRUE)
}
\arguments{
\item{fit}{an object of class \code{lm}, i.e. the output from \code{\link{lm}}.}

\item{conf.level}{confidence level of the intervals.}

\item{print.out}{if \code{TRUE}, print out the output on the screen.}
}
\value{
The function returns a two-column matrix containing the upper and
lower endpoints of the intervals.
}
\description{
Calculates and prints the confidence intervals for the fitted model.
}
\examples{

##Peruvian Indians data
data(peru.df)
fit=lm(BP ~ age + years + weight + height, data = peru.df)
ciReg(fit)

}
\seealso{
\code{\link{lm}}, \code{\link{summary}}, \code{\link{anova}}.
}
\keyword{htest}
