% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatMHMMR.R
\docType{class}
\name{StatMHMMR-class}
\alias{StatMHMMR-class}
\alias{StatMHMMR}
\title{A Reference Class which contains statistics of a MHMMR model.}
\description{
StatMHMMR contains all the statistics associated to a \link[=ParamMHMMR]{MHMMR}
model. It mainly includes the E-Step of the EM algorithm calculating the
posterior distribution of the hidden variables (ie the smoothing
probabilities), as well as the calculation of the prediction and filtering
probabilities, the log-likelhood at each step of the algorithm and the
obtained values of model selection criteria..
}
\section{Fields}{

\describe{
\item{\code{tau_tk}}{Matrix of size \eqn{(m, K)} giving the posterior probability
that the observation \eqn{Y_{i}} originates from the \eqn{k}-th regression
model.}

\item{\code{alpha_tk}}{Matrix of size \eqn{(m, K)} giving the forwards
probabilities: \eqn{P(Y_{1},\dots,Y_{t}, z_{t} = k)}{P(Y_{1},\dots,Y_{t},
  z_{t} = k)}.}

\item{\code{beta_tk}}{Matrix of size \eqn{(m, K)}, giving the backwards
probabilities: \eqn{P(Y_{t+1},\dots,Y_{m} | z_{t} =
  k)}{P(Y_{t+1},\dots,Y_{m} | z_{t} = k)}.}

\item{\code{xi_tkl}}{Array of size \eqn{(m - 1, K, K)} giving the joint post
probabilities: \eqn{xi_tk[t, k, l] = P(z_{t} = k, z_{t-1} = l |
  \boldsymbol{Y})}{xi_tk[t, k, l] = P(z_{t} = k, z_{t-1} = l | Y)} for \eqn{t
  = 2,\dots,m}.}

\item{\code{f_tk}}{Matrix of size \eqn{(m, K)} giving the cumulative distribution
function \eqn{f(y_{t} | z{_t} = k)}{f(y_{t} | z_{t} = k)}.}

\item{\code{log_f_tk}}{Matrix of size \eqn{(m, K)} giving the logarithm of the
cumulative distribution \code{f_tk}.}

\item{\code{loglik}}{Numeric. Log-likelihood of the MHMMR model.}

\item{\code{stored_loglik}}{Numeric vector. Stored values of the log-likelihood at
each iteration of the EM algorithm.}

\item{\code{klas}}{Column matrix of the labels issued from \code{z_ik}. Its elements are
\eqn{klas(i) = k}, \eqn{k = 1,\dots,K}.}

\item{\code{z_ik}}{Hard segmentation logical matrix of dimension \eqn{(m, K)}
obtained by the Maximum a posteriori (MAP) rule: \eqn{z\_ik = 1 \
  \textrm{if} \ z\_ik = \textrm{arg} \ \textrm{max}_{s} \ P(z_{i} = s |
  \boldsymbol{Y})  = tau\_tk;\ 0 \ \textrm{otherwise}}{z_ik = 1 if z_ik = arg
  max_s P(z_{i} = s | Y)  = tau_tk; 0 otherwise}, \eqn{k = 1,\dots,K}.}

\item{\code{state_probs}}{Matrix of size \eqn{(m, K)} giving the distribution of the
Markov chain.
\eqn{P(z_{1},\dots,z_{m};\pi,\boldsymbol{A})}{P(z_{1},\dots,z_{m};\pi,A)}
with \eqn{\pi} the prior probabilities (field \code{prior} of the class
\link{ParamMHMMR}) and \eqn{\boldsymbol{A}}{A} the transition matrix
(field \code{trans_mat} of the class \link{ParamMHMMR}) of the Markov
chain.}

\item{\code{BIC}}{Numeric. Value of BIC (Bayesian Information Criterion).}

\item{\code{AIC}}{Numeric. Value of AIC (Akaike Information Criterion).}

\item{\code{regressors}}{Matrix of size \eqn{(m, K)} giving the values of the
estimated polynomial regression components.}

\item{\code{predict_prob}}{Matrix of size \eqn{(m, K)} giving the prediction
probabilities: \eqn{P(z_{t} = k | y_{1},\dots,y_{t-1})}{P(z_{t} = k |
  y_{1},\dots,y_{t-1})}.}

\item{\code{predicted}}{Row matrix of size \eqn{(m, 1)} giving the sum of the
polynomial components weighted by the prediction probabilities
\code{predict_prob}.}

\item{\code{filter_prob}}{Matrix of size \eqn{(m, K)} giving the filtering
probabilities \eqn{Pr(z_{t} = k | y_{1},\dots,y_{t})}{Pr(z_{t} = k |
  y_{1},\dots,y_{t})}.}

\item{\code{filtered}}{Row matrix of size \eqn{(m, 1)} giving the sum of the
polynomial components weighted by the filtering probabilities.}

\item{\code{smoothed_regressors}}{Matrix of size \eqn{(m, K)} giving the polynomial
components weighted by the posterior probability \code{tau_tk}.}

\item{\code{smoothed}}{Row matrix of size \eqn{(m, 1)} giving the sum of the
polynomial components weighted by the posterior probability \code{tau_tk}.}
}}

\section{Methods}{

\describe{
\item{\code{computeLikelihood(paramMHMMR)}}{Method to compute the log-likelihood based on some parameters given by
the object \code{paramMHMMR} of class \link{ParamMHMMR}.}

\item{\code{computeStats(paramMHMMR)}}{Method used in the EM algorithm to compute statistics based on
parameters provided by the object \code{paramMHMMR} of class
\link{ParamMHMMR}.}

\item{\code{EStep(paramMHMMR)}}{Method used in the EM algorithm to update statistics based on parameters
provided by the object \code{paramMHMMR} of class \link{ParamMHMMR}
(prior and posterior probabilities).}

\item{\code{MAP()}}{MAP calculates values of the fields \code{z_ik} and \code{klas}
      by applying the Maximum A Posteriori Bayes allocation rule.

      \eqn{z\_ik = 1 \ \textrm{if} \ z\_ik = \textrm{arg} \
      \textrm{max}_{s} \ P(z_{i} = s | \boldsymbol{Y})  = tau\_tk;\ 0 \
      \textrm{otherwise}}{z_ik = 1 if z_ik = arg max_s P(z_{i} = s | Y)  =
      tau_tk; 0 otherwise}}
}}

\seealso{
\link{ParamMHMMR}
}
