% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R, R/tab.R
\name{chop_proportions}
\alias{chop_proportions}
\alias{brk_proportions}
\alias{tab_proportions}
\title{Chop into proportions of the range of x}
\usage{
chop_proportions(x, proportions, ..., raw = TRUE)

brk_proportions(proportions)

tab_proportions(x, proportions, ..., raw = TRUE)
}
\arguments{
\item{x}{A vector.}

\item{proportions}{Numeric vector between 0 and 1: proportions of x's range.
If \code{proportions} has names, these will be used for labels.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{raw}{Logical. Use raw values in labels?}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_proportions()} chops \code{x} into \code{proportions} of its range, excluding
infinite values.
}
\details{
By default, labels show the raw numeric endpoints. To label intervals by
the proportions, use \code{raw = FALSE}.
}
\examples{
chop_proportions(0:10, c(0.2, 0.8))
chop_proportions(0:10, c(Low = 0, Mid = 0.2, High = 0.8))

}
\seealso{
Other chopping functions: 
\code{\link{chop}()},
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_fn}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
