% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.compare.jury.stats.r
\name{sim.compare.jury.stats}
\alias{sim.compare.jury.stats}
\title{Estimates jury-level differences based on juror-level statistics using simulations based on empirical data}
\usage{
sim.compare.jury.stats(
  pg_actual,
  n_actual,
  pg_hypo,
  n_hypo,
  jury_n = 12,
  digits = 3,
  pstrikes = 0,
  dstrikes = 0,
  accuracy = 0.15,
  seed = 12345,
  nDraws = 10000
)
}
\arguments{
\item{pg_actual}{The proportion of jurors who favor a guilty verdict in the actual trial condition (the trial with error).}

\item{n_actual}{The size of the sample used to estimate pg_actual.}

\item{pg_hypo}{The proportion of jurors who favor a guilty verdict in the hypothetical trial condition (the fair trial without error).}

\item{n_hypo}{The size of the sample used to estimate pg_hypo.}

\item{jury_n}{Size of the jury (i.e. 6, 8, or 12); default value is 12.}

\item{digits}{Number of digits to report after decimal places; default value is 3.}

\item{pstrikes}{Number of peremptory strikes by prosecution; default value is 0.}

\item{dstrikes}{Number of peremptory strikes by defendant; default value is 0.}

\item{accuracy}{Accuracy of parties' peremptory strikes; a number between 0 and 1; default value is .15.}

\item{seed}{Set seed for random number generation for replication, default is 12345.}

\item{nDraws}{The number of simulations used to generate results. Should be very large number (default = 10000).}
}
\value{
Returns a list of jury-level statistics to assess effect of a trial error.
}
\description{
Calculates jury-level differences based on juror-level statistics supplied by user.
             Results based on empirical data, inferential statistics produced via simulations.
}
\examples{
   library(sate)
   sim.compare.jury.stats(pg_actual=.70, n_actual=400, pg_hypo=.60, n_hypo=450, nDraws=500)

   sim.compare.jury.stats(pg_actual=.75, n_actual=450, pg_hypo=.65, n_hypo=350,
                      seed=12345, nDraws=1000)
}
