% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Color_Palettes.R
\name{Single_Color_Palette}
\alias{Single_Color_Palette}
\title{Single Color Palettes for Plotting}
\usage{
Single_Color_Palette(pal_color, num_colors = NULL, seed_use = 123)
}
\arguments{
\item{pal_color}{color palette to select (Options are: 'reds', 'blues',
'greens', 'purples', 'oranges', 'grays').}

\item{num_colors}{set number of colors (max = 7).}

\item{seed_use}{set seed for reproducibility (default: 123).}
}
\value{
A vector of colors
}
\description{
Selects colors from modified versions of RColorBrewer single colors palettes
}
\examples{
pal <- Single_Color_Palette(pal_color = "reds", num_colors = 7)
PalettePlot(pal= pal)

}
\references{
See RColorBrewer for more info on palettes
\url{https://CRAN.R-project.org/package=RColorBrewer}
}
\concept{palettes}
