% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPN.R
\name{PPN}
\alias{PPN}
\title{Construct Peak-Peak Network}
\usage{
PPN(
  X,
  peak_data,
  cell_data,
  genome,
  dirpath = tempdir(),
  rebuild_PPN = TRUE,
  save_file = TRUE,
  seed = NULL
)
}
\arguments{
\item{X}{The scATAC-seq data, sparse matrix.}

\item{peak_data}{The information for peaks, must have a col names "peak_name".}

\item{cell_data}{The information for cells, must have a col names "cell_name".}

\item{genome}{The genome length for the species.}

\item{dirpath}{The folder path to read or write file.}

\item{rebuild_PPN}{Logical. Whether to rebuild the peak-peak network (PPN) from scratch. If FALSE, the function will attempt to read from \code{PPN.mtx} under \code{dirpath/test} in \code{single} mode or \code{dirpath/state_name/test} in \code{compare} mode.}

\item{save_file}{Logical, whether to save the output to a file.}

\item{seed}{An integer specifying the random seed to ensure reproducible results.}
}
\value{
The PPN network.
}
\description{
Construct peak-peak network.
}
\examples{
\donttest{
library(scPOEM)
library(monocle)
dirpath <- "./example_data"
# Download single mode example data
data(example_data_single)
# Construct PPN net.
pp_net <- PPN(example_data_single$X,
              example_data_single$peak_data,
              example_data_single$cell_data,
              example_data_single$genome,
              file.path(dirpath, "single"),
              save_file=FALSE)
}

}
