% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prepare_data_gaussian_cpp}
\alias{prepare_data_gaussian_cpp}
\title{Generate Gaussian MC samples}
\usage{
prepare_data_gaussian_cpp(MC_samples_mat, x_explain_mat, S, mu, cov_mat)
}
\arguments{
\item{MC_samples_mat}{arma::mat.
Matrix of dimension (\code{n_MC_samples}, \code{n_features}) containing samples from the univariate standard normal.}

\item{x_explain_mat}{arma::mat.
Matrix of dimension (\code{n_explain}, \code{n_features}) containing the observations to explain.}

\item{S}{arma::mat.
Matrix of dimension (\code{n_coalitions}, \code{n_features}) containing binary representations of the used coalitions.
S cannot contain the empty or grand coalition, i.e., a row containing only zeros or ones.
This is not a problem internally in shapr as the empty and grand coalitions are treated differently.}

\item{mu}{arma::vec.
Vector of length \code{n_features} containing the mean of each feature.}

\item{cov_mat}{arma::mat.
Matrix of dimension (\code{n_features}, \code{n_features}) containing the covariance matrix of the features.}
}
\value{
An arma::cube/3D array of dimension (\code{n_MC_samples}, \code{n_explain} * \code{n_coalitions}, \code{n_features}), where
the columns (\emph{,j,}) are matrices of dimension (\code{n_MC_samples}, \code{n_features}) containing the conditional Gaussian
MC samples for each explicand and coalition.
}
\description{
Generate Gaussian MC samples
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
