% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDECsnowQuery.R
\name{CDECsnowQuery}
\alias{CDECsnowQuery}
\title{Get snow survey data (California only) from the CDEC website.}
\usage{
CDECsnowQuery(course, start_yr, end_yr)
}
\arguments{
\item{course}{integer, course number (e.g. 129)}

\item{start_yr}{integer, the starting year (e.g. 2010)}

\item{end_yr}{integer, the ending year (e.g. 2013)}
}
\value{
A \code{data.frame} with results from CDEC.
}
\description{
Get snow survey data (California only) from the CDEC website.
}
\details{
This function downloads data from the CDEC website, therefore an internet connection is required. The \code{SWE} column contains adjusted SWE if available (\code{Adjusted} column), otherwise the reported SWE is used (\code{Water} column). See the \href{http://ncss-tech.github.io/AQP/sharpshootR/CA-snow-survey.html}{tutorial} for examples.
}
\note{
Snow course locations, ID numbers, and other information can be found here: \url{http://cdec.water.ca.gov/misc/SnowCourses.html}
}
\references{
\url{http://cdec.water.ca.gov/cgi-progs/snowQuery}
}
\author{
D.E. Beaudette
}
