% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizSurfaceShape.R
\name{vizSurfaceShape}
\alias{vizSurfaceShape}
\title{Visual Summary of Surface Shape}
\usage{
vizSurfaceShape(
  x,
  title = "Surface Shape",
  s = NULL,
  annotations = TRUE,
  annotation.cex = 0.75,
  cols = c("#2B83BA", "#FFFFBF", "#D7191C", "#808080", "darkgreen"),
  ...
)
}
\arguments{
\item{x}{\code{data.frame} as created by \code{soilDB::fetchOSD(..., extended = TRUE)}, see details}

\item{title}{a reasonable title for the figure}

\item{s}{an optional soil series name, highlighted in the figure}

\item{annotations}{logical, add number of record and normalized Shannon entropy values}

\item{annotation.cex}{annotation label scaling factor}

\item{cols}{vector of colors}

\item{\dots}{additional arguments to \code{\link[=iterateHydOrder]{iterateHydOrder()}}: \verb{target = 0.9, maxIter = 20, j.amount = 0.05, verbose = FALSE}}
}
\value{
A \code{list} with the following elements:
\itemize{
\item \code{fig}: lattice object (the figure)
\item \code{order}: 1D ordering from \code{cluster::diana}
\item \code{clust}: \code{hclust} object
\item \code{match.rate}: fraction of series matching target hydrologic ordering, after clustering + rotation
}
}
\description{
A unique display of surface shape (typically curvature) probability, suitable for across-slope or down-slope shape. Use the \code{title} argument to make this clear.
}
\details{
See the \href{http://ncss-tech.github.io/AQP/soilDB/soil-series-query-functions.html}{Soil Series Query Functions} tutorial for more information.
}
\author{
D.E. Beaudette
}
