% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{load_example}
\alias{load_example}
\title{Load an application and instructions to run shiny.benchmark}
\usage{
load_example(path, force = FALSE)
}
\arguments{
\item{path}{A character vector of full path name}

\item{force}{Create example even if directory does not exist or is not empty}
}
\value{
Print on the console instructions to run the example
}
\description{
This function aims to generate a template to be used
by shiny.benchmark. It will create the necessary structure on \code{path} with
some examples of tests using Cypress and shinytest2. Also, a simple
application will be added to the folder as well as instructions on how
to perform the performance checks. Be aware that a new git repo is need in
the selected \code{path}.
}
\examples{
load_example(file.path(tempdir(), "example_destination"), force = TRUE)
}
