% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_cypress.R
\name{run_cypress_ptest}
\alias{run_cypress_ptest}
\title{Run the performance test based on a single commit using Cypress}
\usage{
run_cypress_ptest(
  commit,
  project_path,
  cypress_dir,
  tests_pattern,
  use_renv,
  renv_prompt,
  n_rep,
  debug
)
}
\arguments{
\item{commit}{A commit hash code or a branch's name}

\item{project_path}{The path to the project with all needed packages
installed}

\item{cypress_dir}{The directory with tests recorded by Cypress}

\item{tests_pattern}{Cypress files pattern. E.g. 'performance'. If it is NULL,
all the content will be used}

\item{use_renv}{In case it is set as TRUE, package will try to apply
renv::restore() in all branches. Otherwise, the current loaded list of
packages will be used in all branches.}

\item{renv_prompt}{Prompt the user before taking any action?}

\item{n_rep}{Number of replications desired}

\item{debug}{Logical. TRUE to display all the system messages on runtime}
}
\value{
Return a \code{data.frame} with the collected performance time
}
\description{
Run the performance test based on a single commit using Cypress
}
