% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{postCij}
\alias{postCij}
\title{Sample a vector of values from the full conditional posterior of the c_ij vector}
\usage{
postCij(yijs, pi, muis, tauis)
}
\arguments{
\item{yijs}{Numeric Vector, cycle lengths}

\item{pi}{Numeric vector, must sum to 1. Sampled probabilities for c_ijs}

\item{muis}{Numeric vector, log of sampled mean for all individuals yijs}

\item{tauis}{Numeric vector > 0, sampled precision for all individuals yijs}
}
\value{
Integer vector
}
\description{
In our model the data are drawn from LogN(mu_i + log(c_ij), tau_i) The prior for
c_ij is a categorical prior with category probabilities pi1, ..., pik, and c_ij can
take values 1, ..., k where k is the length of pi. This function samples from the
full conditional posterior of all c_ijs, given vectors of equal length yijs, muis, tauis
}
