% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{sky.objects}
\alias{sky.objects}
\title{Creates a \emph{skyscapeR.object} for plotting of celestial objects at given epoch}
\usage{
sky.objects(names, epoch, loc = FALSE, col = "red", lty = 1, lwd = 1)
}
\arguments{
\item{names}{The name(s) of the celestial object(s) or event(s) of interest.
These can be one of the following soli-lunar events: \emph{jS}, \emph{dS}, \emph{eq},
 \emph{nmnLX}, \emph{nMjLX},
\emph{smnLX}, \emph{sMjLX}, or the name of any star in the database. As shorthand, the names
\emph{sun} and \emph{moon} can be used to represent all the above solar and lunar events,
respectively. Alternatively, custom declination values can also be used.}

\item{epoch}{The year or year range (as an array) one is interested in.}

\item{loc}{(Optional) This can be either a vector with the latitude and longitude of the
location, or a \emph{skyscapeR.horizon} object.}

\item{col}{(Optional) The color for plotting, and differentiating these objects.
Defaults to red for all objects.}

\item{lty}{(Optional) Line type (see \code{\link{par}}) used for differentiation.
Only activated for single year epochs.}

\item{lwd}{(Optional) Line width (see \code{\link{par}}) used for differentiation.
Only activated for single year epochs.}
}
\description{
This function creates an object containing all the necessary information to
plot celestial objects/events unto the many plotting functions of \emph{skyscapeR}
package.
}
\examples{
# Create a object with solar targets for epoch range 4000-2000 BC:
tt <- sky.objects('solar extremes', c(-4000,-2000))

# Create an object with a few stars for same epoch:
tt <- sky.objects(c('Sirius', 'Betelgeuse', 'Antares'), c(-4000,-2000),
col=c('white', 'red', 'orange'))

# Create an object with solstices and a custom declination value:
tt <- sky.objects(c('December Solstice','June Solstice', -13), c(-4000,-2000))
}
