% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeStretch.R
\name{timeStretch}
\alias{timeStretch}
\title{Time stretch}
\usage{
timeStretch(
  x,
  stretch = 1,
  samplingRate = NULL,
  precision = 1000,
  play = FALSE,
  saveAudio = NULL,
  reportEvery = NULL,
  cores = 1
)
}
\arguments{
\item{x}{path to a folder, one or more wav or mp3 files c('file1.wav',
'file2.mp3'), Wave object, numeric vector, or a list of Wave objects or
numeric vectors}

\item{stretch}{1 = no change, >1 = longer, <1 = shorter. Single value, vector,
or anchor format (see \code{\link{soundgen}})}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{precision}{the number of points used for estimating the duration of
output (more = better, but slower)}

\item{play}{if TRUE, plays the synthesized sound using the default player on
your system. If character, passed to \code{\link[tuneR]{play}} as the name
of player to use, eg "aplay", "play", "vlc", etc. In case of errors, try
setting another default player for \code{\link[tuneR]{play}}}

\item{saveAudio}{full path to the folder in which to save audio files (one
per detected syllable)}

\item{reportEvery}{when processing multiple inputs, report estimated time
left every ... iterations (NULL = default, NA = don't report)}

\item{cores}{number of cores for parallel processing}
}
\description{
Dynamically time-stretches a sound without preserving its pitch or formants,
as if gradually changing playback speed. Algorithm: the audio is resampled at
time-varying steps. This is about 100 times faster than time-stretching with a
phase vocoder in \code{\link{shiftPitch}}, but pitch and formants cannot be
preserved, and large stretch factors may cause artifacts due to aliasing.
}
\examples{
data(sheep, package = 'seewave')  # import a recording from seewave
# playme(sheep)
# spectrogram(sheep)
s1 = timeStretch(sheep, stretch = c(1, 3))
# playme(s1, sheep@samp.rate)
# spectrogram(s1, sheep@samp.rate)

# compare to a similar effect achieved with a phase vocoder in pitchShift():
s2 = shiftPitch(
  sheep,
  timeStretch = c(1, 3),  # from 1 (original) to mult
  multPitch = c(1, 1/3),  # also drop pitch
  multFormants = c(1, 1/3)  # also drop formants (by the same proportion)
)
# playme(s2, sheep@samp.rate)
# spectrogram(s2, sheep@samp.rate)
# NB: because the two algorithms calculate transitions between stretch
# factors in different ways, the duration is not identical, even though the
# range of pitch change is the same
}
\seealso{
\code{\link{shiftPitch}}
}
