% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_tbl.R
\name{select_tbl}
\alias{select_tbl}
\title{Summarize multiple response variables}
\usage{
select_tbl(
  data,
  var_stem,
  escape_stem = FALSE,
  ignore_stem_case = FALSE,
  na_removal = "listwise",
  pivot = "longer",
  only = NULL,
  var_labels = NULL,
  ignore = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{var_stem}{A character string of a variable stem or the full name of a variable
in \code{data}.}

\item{escape_stem}{A logical value indicating whether to escape \code{var_stem}. Default
is \code{FALSE}.}

\item{ignore_stem_case}{A logical value indicating whether the search for columns
matching the supplied \code{var_stem} is case-insensitive. Default is \code{FALSE}.}

\item{na_removal}{A character string specifying how to remove missing values. Should
be one of \code{pairwise} or \code{listwise}. Default is \code{listwise}.}

\item{pivot}{A character string specifying the format of the returned summary table.
The default is \code{longer}, which returns the data in long format. To return the data in
wide format, use \code{wider}.}

\item{only}{A character string or vector of character strings of the kinds of summary
data to return. Default is \code{NULL}, which returns counts (count) and percentages (percent).}

\item{var_labels}{An optional named character vector or list where each element maps
labels to variable names. If any element is unnamed or if any labels do not match
variables in returned from \code{data}, all labels will be ignored and the table will be
printed without them.}

\item{ignore}{An optional vector that contains values to exclude from the data. Default
is \code{NULL}, which includes all present values.}
}
\value{
A tibble displaying frequency counts and/or percentages for each value of a
set of variables sharing the same variable stem. When the output is in the wider format,
columns beginning with \code{count_value} and \code{percent_value} prefixes report the count and
percentage, respectively, for each distinct response  value of the variable.
}
\description{
\code{select_tbl()} presents frequency counts and percentages
(count, percent) for binary (e.g., Unselected/Selected) and ordinal (e.g.,
strongly disagree to strongly agree) variables with the same variable stem.
A variable stem is a common prefix found in related variable names, often
corresponding to similar survey items, that represents a shared concept before
unique identifiers (like time points) are added. For example, in the \code{stem_social_psych}
dataset, the two variables \code{belong_belongStem_w1} and \code{belong_belongStem_w2}
share the variable stem \code{belong_belongStem} (e.g., "I feel like an outsider in
STEM"), with suffixes (_w1, _w2) indicating different measurement waves. By
default, missing data are excluded from the calculations in a listwise fashion.
}
\examples{
select_tbl(data = tas,
           var_stem = "involved_",
           na_removal = "pairwise")

select_tbl(data = depressive,
           var_stem = "dep",
           na_removal = "listwise",
           pivot = "wider",
           only = "percent")

var_label_example <-
  c("dep_1" = "how often child feels sad and blue",
    "dep_2" = "how often child feels nervous, tense, or on edge",
    "dep_3" = "how often child feels happy",
    "dep_4" = "how often child feels bored",
    "dep_5" = "how often child feels lonely",
    "dep_6" = "how often child feels tired or worn out",
    "dep_7" = "how often child feels excited about something",
    "dep_8" = "how often child feels too busy to get everything")

select_tbl(data = depressive,
           var_stem = "dep",
           na_removal = "pairwise",
           pivot = "longer",
           var_labels = var_label_example)

select_tbl(data = depressive,
           var_stem = "dep",
           na_removal = "pairwise",
           pivot = "wider",
           only = "count",
           var_labels = var_label_example)

}
\author{
Ama Nyame-Mensah
}
