% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_quarto_raw.R
\name{tar_quarto_run}
\alias{tar_quarto_run}
\title{Render a Quarto project inside a \code{tar_quarto()} target.}
\usage{
tar_quarto_run(args, deps, sources, output, input)
}
\arguments{
\item{args}{A named list of arguments to \code{quarto::quarto_render()}.}

\item{deps}{An unnamed list of target dependencies of the Quarto
source files.}

\item{sources}{Character vector of Quarto source files.}

\item{output}{Character vector of Quarto output files and directories.}

\item{input}{Character vector of non-source Quarto input files
and directories.}
}
\value{
Sorted character vector with the paths to all the important
files that \code{targets} should track for changes.
}
\description{
Internal function needed for \code{tar_quarto()}.
Users should not invoke it directly.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({  # tar_dir() runs code from a temporary directory.
# Unparameterized Quarto document:
lines <- c(
  "---",
  "title: Quarto source file",
  "output_format: html",
  "---",
  "Assume these lines are in the Quarto source file.",
  "```{r}",
  "1 + 1",
  "```"
)
tmp <- tempfile(fileext = ".qmd")
writeLines(lines, tmp)
args <- list(input = tmp, quiet = TRUE)
files <- fs::path_ext_set(tmp, "html")
tar_quarto_run(args = args, deps = list(), files = files)
file.exists(files)
})
}
}
\keyword{internal}
