% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_gcp.R
\name{tar_resources_gcp}
\alias{tar_resources_gcp}
\title{Target resources: Google Cloud Platform (GCP)
Google Cloud Storage (GCS)}
\usage{
tar_resources_gcp(
  bucket = targets::tar_option_get("resources")$gcp$bucket,
  prefix = targets::tar_option_get("resources")$gcp$prefix,
  predefined_acl = targets::tar_option_get("resources")$gcp$predefined_acl,
  max_tries = targets::tar_option_get("resources")$gcp$max_tries,
  verbose = targets::tar_option_get("resources")$gcp$verbose
)
}
\arguments{
\item{bucket}{Character of length 1, name of an existing
bucket to upload and download the return values
of the affected targets during the pipeline.}

\item{prefix}{Character of length 1, "directory path"
in the bucket where your target object and metadata will go.
Please supply an explicit prefix
unique to your \code{targets} project.
In the future, \code{targets} will begin requiring
explicitly user-supplied prefixes. (This last note
was added on 2023-08-24: \code{targets} version 1.2.2.9000.)}

\item{predefined_acl}{Character of length 1, user access
to the object. See \code{?googleCloudStorageR::gcs_upload}
for possible values. Defaults to \code{"private"}.}

\item{max_tries}{Positive integer of length 1,
number of tries accessing a network resource on GCP.}

\item{verbose}{Logical of length 1, whether to print
extra messages like progress bars during uploads
and downloads. Defaults to \code{FALSE}.}
}
\value{
Object of class \code{"tar_resources_gcp"}, to be supplied
to the \code{gcp} argument of \code{tar_resources()}.
}
\description{
Create the \code{gcp} argument of \code{tar_resources()}
to specify optional settings for Google Cloud Storage for
targets with \code{tar_target(..., repository = "gcp")}.
See the \code{format} argument of \code{\link[=tar_target]{tar_target()}} for details.
}
\details{
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.

In \code{targets} version 0.12.2 and above, resources are inherited one-by-one
in nested fashion from \code{tar_option_get("resources")}.
For example, suppose you set
\code{tar_option_set(resources = tar_resources(aws = my_aws))},
where \code{my_aws} equals \code{tar_resources_aws(bucket = "x", prefix = "y")}.
Then, \verb{tar_target(data, get_data()} will have bucket \code{"x"} and
prefix \code{"y"}. In addition, if \code{new_resources} equals
\verb{tar_resources(aws = tar_resources_aws(bucket = "z")))}, then
\code{tar_target(data, get_data(), resources = new_resources)}
will use the new bucket \code{"z"}, but it will still use the prefix \code{"y"}
supplied through \code{tar_option_set()}. (In \code{targets} 0.12.1 and below,
options like \code{prefix} do not carry over from \code{tar_option_set()} if you
supply non-default resources to \code{tar_target()}.)
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  format = "qs",
  repository = "gcp",
  resources = tar_resources(
    gcp = tar_resources_gcp(
      bucket = "yourbucketname",
      prefix = "_targets"
    ),
    qs = tar_resources_qs(preset = "fast"),
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources}()},
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_crew}()},
\code{\link{tar_resources_custom_format}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_network}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_repository_cas}()},
\code{\link{tar_resources_url}()}
}
\concept{resources}
