% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_mods.R
\name{emax_inv_remi}
\alias{emax_inv_remi}
\title{Inverse Emax function implemented by Eleveld remifentanil model}
\usage{
emax_inv_remi(pdresp, pars)
}
\arguments{
\item{pdresp}{PD response values}

\item{pars}{Named vector of parameter values with names (c50,gamma,E0,Emx).}
}
\value{
Numeric vector of same length as pdresp.
}
\description{
Inverse Emax function to return effect-site concentrations required to reach target effect.
}
\examples{
pars_emax <- c(e0 = 19, emx = 5.6, c50 = 12.7, gamma = 2.87)
emax_inv_remi(emax_remi(10, pars_emax), pars_emax)
}
