% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_mods.R
\name{emax_inv}
\alias{emax_inv}
\title{Inverse Emax function}
\usage{
emax_inv(pdresp, pars)
}
\arguments{
\item{pdresp}{PD response values}

\item{pars}{Named vector of parameter values with names (c50,gamma,E0,Emx).}
}
\value{
Numeric vector of same length as pdresp.
}
\description{
Inverse Emax function to return effect-site concentrations required to reach target effect.
}
\examples{
pars_emax <- c(c50 = 1.5, gamma = 4, e0 = 100, emx = 100)
ce_seq <- seq(0,4,0.1)
all.equal(emax_inv(emax(ce_seq, pars_emax), pars_emax), ce_seq)
}
