% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_abnormality.R
\name{template_abnormality}
\alias{template_abnormality}
\title{Template: Abnormality Summary Table}
\usage{
template_abnormality(
  parentname,
  dataname,
  arm_var,
  id_var = "USUBJID",
  by_vars,
  abnormal = list(low = c("LOW", "LOW LOW"), high = c("HIGH", "HIGH HIGH")),
  grade = "ANRIND",
  baseline_var = "BNRIND",
  treatment_flag_var = "ONTRTFL",
  treatment_flag = "Y",
  add_total = FALSE,
  total_label = default_total_label(),
  exclude_base_abn = FALSE,
  drop_arm_levels = TRUE,
  na_level = tern::default_na_str(),
  basic_table_args = teal.widgets::basic_table_args(),
  tbl_title
)
}
\arguments{
\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{arm_var}{(\code{character})\cr variable names that can be used as \code{arm_var}.}

\item{id_var}{(\code{character})\cr the variable name for subject id.}

\item{by_vars}{(\code{character})\cr variable names used to split the summary by rows.}

\item{abnormal}{(\verb{named list})\cr indicating abnormality direction and grades.}

\item{grade}{(\code{character})\cr name of the variable used to
specify the abnormality grade. Variable must be factor.}

\item{baseline_var}{(\code{character})\cr
name of the variable specifying baseline abnormality grade.}

\item{treatment_flag_var}{(\code{character})\cr name of the on treatment flag variable.}

\item{treatment_flag}{(\code{character})\cr name of the value indicating on treatment
records in \code{treatment_flag_var}.}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{exclude_base_abn}{(\code{logical})\cr whether to exclude patients who had abnormal values at baseline.}

\item{drop_arm_levels}{(\code{logical})\cr whether to drop unused levels of \code{arm_var}. If \code{TRUE}, \code{arm_var} levels are
set to those used in the \code{dataname} dataset. If \code{FALSE}, \code{arm_var} levels are set to those used in the
\code{parentname} dataset. If \code{dataname} and \code{parentname} are the same, then \code{drop_arm_levels} is set to \code{TRUE} and
user input for this parameter is ignored.}

\item{na_level}{(\code{character})\cr the NA level in the input dataset, defaults to \code{"<Missing>"}.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}

\item{tbl_title}{(\code{character})\cr Title with label of variables from by bars}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a table to summarize abnormality.
}
\seealso{
\code{\link[=tm_t_abnormality]{tm_t_abnormality()}}
}
\keyword{internal}
