% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_card.R
\name{prep_hierarchical_fill}
\alias{prep_hierarchical_fill}
\title{Fill missing values in hierarchical variables}
\usage{
prep_hierarchical_fill(
  df,
  vars,
  fill = "Any {colname}",
  fill_from_left = FALSE
)
}
\arguments{
\item{df}{(data.frame)}

\item{vars}{(character) a vector of variables to generate pairs from.}

\item{fill}{(character) value to replace with. Defaults to \code{"Any {colname}"},
in which case \code{colname} will be replaced with the name of the column.}

\item{fill_from_left}{(logical) indicating whether to fill from the left
(first) column in the pair. Defaults to \code{FALSE}. If \code{TRUE} it takes
precedence over \code{fill}.}
}
\value{
a data.frame with the same columns as the input, but in which some
the desired columns have been filled pairwise.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Replace \code{NA} values in one column conditional on the same row having a
non-NA value in a different column.

The user supplies a vector of columns from which the pairs will be extracted
with a rolling window. For example \code{vars <- c("A", "B", "C")} will generate
2 pairs \verb{("A", "B")} and \verb{("B", "C")}. Therefore the order of the variables
matters.

In each pair the second column \code{B} will be filled if \code{A} is not missing. One
can choose the value to fill with:
\itemize{
\item \code{"Any {colname}"}, in this case evaluating to \code{"Any B"} is the default.
\item Any other value. For example \code{"Any event"} for an adverse effects table.
\item the value of pair's first column. In this case, the value of \code{A}.
}
}
\examples{
df <- data.frame(
  x = c(1, 2, NA),
  y = c("a", NA, "b"),
  z = rep(NA, 3)
)

prep_hierarchical_fill(
  df,
  vars = c("x", "y")
)

prep_hierarchical_fill(
  df,
  vars = c("x", "y"),
  fill = "foo"
)

prep_hierarchical_fill(
  df,
  vars = c("x", "y", "z"),
  fill_from_left = TRUE
)
}
