% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.R
\name{norm_lobanov}
\alias{norm_lobanov}
\title{Lobanov Normalize}
\usage{
norm_lobanov(
  .data,
  ...,
  .by = NULL,
  .by_formant = TRUE,
  .drop_orig = FALSE,
  .keep_params = FALSE,
  .names = "{.formant}_z",
  .silent = FALSE
)
}
\arguments{
\item{.data}{A data frame containing vowel formant data}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant
data columns.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A selection of
columns to group by. Typically a column of speaker IDs.}

\item{.by_formant}{Ignored by this procedure}

\item{.drop_orig}{Whether or not to drop the original formant data columns.}

\item{.keep_params}{Whether or not to keep the Location (\verb{*_.L}) and Scale
(\verb{*_.S}) normalization parameters}

\item{.names}{A \code{\link[glue:glue]{glue::glue()}} expression for naming the normalized
data columns. The \code{"{.formant}"} portion corresponds to the name of the original
formant columns.}

\item{.silent}{Whether or not the informational message should be printed.}
}
\value{
A data frame of Lobanov normalized formant values.
}
\description{
Lobanov Normalize
}
\details{
\deqn{
  \hat{F}_{ij} = \frac{F_{ij} - L_i}{S_i}
}

\deqn{
  L_i = \frac{1}{N}\sum_{j=1}^{N}F_{ij}
}

\deqn{
  S_i = \sqrt{\frac{\sum(F_{ij}-L_i)^2}{N-1}}
}

Where
\itemize{
\item \eqn{\hat{F}} is the normalized formant
\item \eqn{i} is the formant number
\item \eqn{j} is the token number
}
}
\examples{
library(tidynorm)
ggplot2_inst <- require(ggplot2)

speaker_data_lobanov <- speaker_data |>
  norm_lobanov(
    F1:F3,
    .by = speaker,
    .names = "{.formant}_z"
  )

if (ggplot2_inst) {
  ggplot(
    speaker_data_lobanov,
    aes(
      F2_z,
      F1_z,
      color = speaker
    )
  ) +
    stat_density_2d(
      bins = 4
    ) +
    scale_color_brewer(
      palette = "Dark2"
    ) +
    scale_x_reverse() +
    scale_y_reverse() +
    coord_fixed()
}
}
\references{
Lobanov, B. (1971). Classification of Russian vowels spoken by different listeners.
Journal of the Acoustical Society of America, 49, 606–608.
}
