% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_pca_tidiers.R
\name{tidy.gt_pca}
\alias{tidy.gt_pca}
\alias{gt_pca_tidiers}
\title{Tidy a \code{gt_pca} object}
\usage{
\method{tidy}{gt_pca}(x, matrix = "eigenvalues", ...)
}
\arguments{
\item{x}{A \code{gt_pca} object returned by one of the \verb{gt_pca_*} functions.}

\item{matrix}{Character specifying which component of the PCA should be
tidied.
\itemize{
\item \code{"samples"}, \code{"scores"}, or \code{"x"}: returns information about
the map from the original space into principle components space
(this is equivalent to product of \emph{u} and \emph{d}).
\item \code{"v"}, \code{"rotation"}, \code{"loadings"} or \code{"variables"}: returns information
about the map from principle components space back into the original
space.
\item \code{"d"}, \code{"eigenvalues"} or \code{"pcs"}: returns information about the
eigenvalues.
}}

\item{...}{Not used. Needed to match generic signature only.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with columns depending on the component of
PCA being tidied.

If \code{"scores"} each row in the
tidied output corresponds to the original data in PCA space. The columns
are:

\item{\code{row}}{ID of the original observation (i.e. rowname from original
data).}
\item{\code{PC}}{Integer indicating a principal component.}
\item{\code{value}}{The score of the observation for that particular principal
component. That is, the location of the observation in PCA space.}

If \code{matrix} is  \code{"loadings"}, each
row in the tidied output corresponds to information about the principle
components in the original space. The columns are:

\item{\code{row}}{The variable labels (colnames) of the data set on
which PCA was performed.}
\item{\code{PC}}{An integer vector indicating the principal component.}
\item{\code{value}}{The value of the eigenvector (axis score) on the
indicated principal component.}

If \code{"eigenvalues"}, the columns are:

\item{\code{PC}}{An integer vector indicating the principal component.}
\item{\code{std.dev}}{Standard deviation (i.e. sqrt(eig/(n-1))) explained by
this PC (for compatibility with \code{prcomp}.}
\item{\code{cumulative}}{Cumulative variation explained by
principal components up to this component (note that this is NOT
phrased as a percentage of total variance, since many methods
only estimate a truncated SVD.}
}
\description{
This summarizes information about the components of a \code{gt_pca} from the
\code{tidypopgen} package. The parameter \code{matrix} determines which element is
returned. Column names of the tidied output match those returned by
\link[broom:tidy.prcomp]{broom::tidy.prcomp}, the tidier for the standard PCA objects returned
by \link[stats:prcomp]{stats::prcomp}.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
lobsters <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Remove monomorphic loci and impute
lobsters <- lobsters \%>\% select_loci_if(loci_maf(genotypes) > 0)
lobsters <- gt_impute_simple(lobsters, method = "mode")

# Create PCA object
pca <- gt_pca_partialSVD(lobsters)

# Tidy the PCA object
tidy(pca)

# Tidy the PCA object for eigenvalues
tidy(pca, matrix = "eigenvalues")

# Tidy the PCA object for loadings
tidy(pca, matrix = "loadings")

# Tidy the PCA object for scores
tidy(pca, matrix = "scores")
}
\seealso{
\code{\link[=gt_pca_autoSVD]{gt_pca_autoSVD()}} \link{augment_gt_pca}
}
