% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{centerTime}
\alias{centerTime}
\title{Move the window such that the given time is centered}
\usage{
centerTime(id, time, options)
}
\arguments{
\item{id}{Timeline id}

\item{time}{The date/time to center around}

\item{options}{Named list of options controlling the animation. Most common
option is \code{"animation" = TRUE/FALSE}. For a full list of options, see
the "moveTo" method in the
\href{http://visjs.org/docs/timeline/#Methods}{official
Timeline documentation}}
}
\description{
Move the window such that the given time is centered
}
\examples{
if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Center around 24 hours ago")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis()
    )
    observeEvent(input$btn, {
      centerTime("timeline", Sys.Date())
    })
  }
)
}
}

