% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{setSelection}
\alias{setSelection}
\title{Select one or multiple items on a timeline}
\usage{
setSelection(id, itemId, options)
}
\arguments{
\item{id}{Timeline id}

\item{itemId}{A vector (or single value) of the item ids to select}

\item{options}{Named list of options controlling mainly the animation.
Most common options are \code{focus = TRUE/FALSE} and
\code{"animation" = TRUE/FALSE}. For a full list of options, see
the "setSelection" method in the
\href{http://visjs.org/docs/timeline/#Methods}{official
Timeline documentation}}
}
\description{
Select one or multiple items on a timeline
}
\examples{
if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    timevisOutput("timeline"),
    actionButton("btn", "Select item 2")
  ),
  server = function(input, output) {
    output$timeline <- renderTimevis(
      timevis(
        data.frame(id = 1:3, start = Sys.Date(), content = 1:3)
      )
    )
    observeEvent(input$btn, {
      setSelection("timeline", 2)
    })
  }
)
}
}

