% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar.R
\name{calendar-names}
\alias{calendar-names}
\alias{month_names}
\alias{weekday_names}
\alias{ampm_indicators}
\title{Calendar Names}
\usage{
month_names(locale = NULL, abbreviate = TRUE)

weekday_names(locale = NULL, abbreviate = TRUE)

ampm_indicators(locale = NULL)
}
\arguments{
\item{locale}{a character value determining locale or \code{NULL} (default,
interpreted as the current system locale).}

\item{abbreviate}{a logical value, if \code{TRUE}, abbreviated names are returned;
if \code{FALSE}, full names are returned.
\code{TRUE} by default.}
}
\value{
A character vector of length 12, 7, or 2.
}
\description{
These three functions return (abbreviated and full) names of months and days of week
as well as AM/PM indicators in the current or user-provided locale.

How the month and weekday names are actually returned depends both on the
selected locale and character set / code page setting.
}
\section{Locale Settings}{

Unfortunately, locale and character set naming were not standardised across
different operating systems for many years. On modern operating systems,
however, locale is usually of the form \code{xx_XX} (\code{xx} for language,
\code{XX} for country) optionally followed by a dot and a character set
identifier, for example, \code{UTF-8}.

\code{"C"} is a special locale that should always be available and
defaults to American English.
}

\examples{
# current system locale
month_names()
weekday_names()
try(
ampm_indicators()
)

try({
# English abbreviated month names
print(month_names("en_GB"))
# French month names
print(month_names("fr_FR.UTF-8", FALSE))
# German abbreviated month names
print(month_names("de_DE.UTF-8"))
# Polish abbreviated month names
print(month_names("pl_PL.UTF-8"))
# English weekday names
print(weekday_names("en_GB", FALSE))
# French abbreviated weekday names
print(weekday_names("fr_FR.UTF-8"))
# German weekday names
print(weekday_names("de_DE.UTF-8", FALSE))
# Polish abbreviated weekday names
print(weekday_names("pl_PL.UTF-8"))
# US am/pm indicators
print(ampm_indicators("en_US"))
# UK am/pm indicators
print(ampm_indicators("en_GB"))
})

}
\seealso{
\code{\link{format}} for formatting objects of \code{tind} class.
}
