% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{av_apply}
\alias{av_apply}
\title{Corrects the matrix profile using an annotation vector}
\usage{
av_apply(.mp)
}
\arguments{
\item{.mp}{A Matrix Profile with an Annotation Vector.}
}
\value{
Returns the input \code{.mp} object corrected by the embedded annotation vector.
}
\description{
This function overwrites the current Matrix Profile using the Annotation Vector. Use with caution.
}
\examples{
data <- mp_test_data$train$data[1:1000]
w <- 50
mp <- tsmp(data, window_size = w, verbose = 0)
mp <- av_complexity(mp)
av <- av_apply(mp)
}
\references{
\itemize{
\item Dau HA, Keogh E. Matrix Profile V: A Generic Technique to Incorporate Domain
Knowledge into Motif Discovery. In: Proceedings of the 23rd ACM SIGKDD International Conference
on Knowledge Discovery and Data Mining - KDD '17. New York, New York, USA: ACM Press; 2017. p.
125-34.
}
}
\seealso{
Other Annotation vectors: 
\code{\link{av_complexity}()},
\code{\link{av_hardlimit_artifact}()},
\code{\link{av_motion_artifact}()},
\code{\link{av_stop_word}()},
\code{\link{av_zerocrossing}()}
}
\concept{Annotation vectors}
