% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{set_credentials}
\alias{set_credentials}
\title{Set and Save VALD API Credentials}
\usage{
set_credentials(client_id, client_secret, tenant_id, region)
}
\arguments{
\item{client_id}{Your VALD API Client ID (stored securely in keyring)}

\item{client_secret}{Your VALD API Client Secret (stored securely in keyring)}

\item{tenant_id}{Your VALD Tenant ID}

\item{region}{The VALD data region code (e.g., "aue", "use", "euw")}
}
\value{
Invisibly returns TRUE if credentials and configuration were saved successfully.
}
\description{
Securely stores VALD API credentials in the system keyring and
saves non-sensitive configuration to a JSON config file in the user's home directory
for reuse across sessions.
}
\details{
Sensitive values (client ID and secret) are never written to disk and
are retrieved securely from the keyring when needed.
}
