% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_project.R
\name{get_project}
\alias{get_project}
\title{Download vein project}
\usage{
get_project(directory, case, url)
}
\arguments{
\item{directory}{Character; Path to an existing or a new directory to be created.}

\item{case}{Character; One of  of the following:
\tabular{llll}{
  \strong{case}  \tab \strong{Description}\tab  \strong{EF} \tab \strong{Notes}   \cr
  argentina  \tab top down\tab COPERT \tab  .rds\cr
  emislacovid  \tab Bottom-up March 2020\tab CETESB \tab  .rds\cr
  brazil_bu_chem     \tab Bottom-up  chemical mechanisms\tab CETESB+tunnel\tab  .rds\cr
  brazil_bu_chem_streets \tab Bottom-up  chemical mechanisms for streets and MUNICH\tab CETESB+tunnel\tab  .rds\cr
  brazil_td_chem     \tab Top-down with chemical mechanisms\tab CETESB\tab  .csv and .rds\cr
  brazil_country     \tab Top down \tab CETESB+tunnel\tab  .rds\cr
  brazil_countryv2     \tab Top down \tab CETESB+tunnel\tab  .rds\cr
  masp2020       \tab Bottom-down\tab CETESB+tunnel\tab  csv and.rds\cr
  sebr_cb05co2   \tab Top-down SP, MG and RJ\tab CETESB+tunnel\tab  .rds\cr
  amazon2014     \tab Top-down Amazon\tab CETESB+tunnel\tab  csv and.rds\cr
  curitiba       \tab Bottom-down +GTFS\tab CETESB+tunnel\tab  csv and.rds\cr
  ecuador     \tab Top-down. Renamed ecuador_td_im\tab EEA\tab  csv and.rds\cr
  moves_bu         \tab Bottom-up\tab US/EPA MOVES \tab  csv and.rds (requires MOVES >=3.0 on Windows)\cr
  manizales_bu     \tab Bottom-up  chemical mechanisms\tab EEA\tab  csv, csv.gz, .rds\cr
  eu_bu_chem       \tab Bottom-up  chemical mechanisms\tab EEA 2019\tab  .rds\cr
  eu_bu_chem_simple\tab Bottom-up  chemical mechanisms 7 veh\tab EEA 2019\tab  .rds\cr
  china_bu_chem    \tab Bottom-up  chemical mechanisms\tab MEE China\tab  .rds\cr
  china_bu_chem_1h    \tab Bottom-up  chemical mechanisms\tab MEE China\tab  .rds\cr
}}

\item{url}{String, with the URL to download VEIN project}
}
\description{
\code{\link{get_project}} downloads a project for running vein.
The projects are available on Github.com/atmoschem/vein/projects
}
\note{
All projects include option to apply survival functions
In Sao Paulo the IM programs was functioning until 2011.
}
\examples{
\dontrun{
#do not run
get_project("awesomecity", case = "brazil_bu_chem")
}

}
