% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gis_analysis_distance.R
\name{wbt_buffer_raster}
\alias{wbt_buffer_raster}
\title{Buffer raster}
\usage{
wbt_buffer_raster(
  input,
  output,
  size,
  gridcells = FALSE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input raster file path. See \code{wbt_file_path()} for details.}

\item{output}{Output raster file.}

\item{size}{Buffer size.}

\item{gridcells}{Optional flag to indicate that the 'size' threshold should be measured in grid cells instead of the default map units.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Maps a distance-based buffer around each non-background (non-zero/non-nodata) grid cell in an input image.
}
\keyword{GISAnalysisDistanceTools}
