% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terminate.R
\name{terminateRelativeErrorZero}
\alias{terminateRelativeErrorZero}
\title{Terminates if relative deviation from optimum is small. Works at 0.}
\usage{
terminateRelativeErrorZero(solution, lF)
}
\arguments{
\item{solution}{A named list with at least the following elements:
$name, $fitness, $value, $numberOfSolutions, 
$genotype, $phenotype, $phenotypeValue.}

\item{lF}{Local function configuration. It must contain
\itemize{
\item \code{lF$penv$globalOptimum()} which returns 
      the global optimum. 
\item \code{lF$TerminationEps()} which specifies the 
      the fraction of the global optimum
      used for computing the upper and lower bounds
      for the interval in which the best current 
      solution must be for terminating the algorithm. 
}}
}
\value{
Boolean.
}
\description{
\code{terminateRelativeErrorZero()} 
returns \code{TRUE} if the value of the current solution 
is in the interval from (globalOptimum - (globalOptimum*eps)) to 
(globalOptimum + (globalOptimum*eps)). If globalOptimum is zero, 
test interval (0-eps) to (0+eps).
}
\details{
Useful for benchmark functions with known global optima.
         Note that for a global optimum of \code{0} this function 
         terminates if the current optimum is between 
         \code{0-terminationEps} and \code{0+terminationEps}.
}
\examples{
    parm<-function(x){function() {return(x)}}
    olst<-list(); olst$value<-0
    penv<-list(); penv$globalOptimum<-parm(olst)
    lF<-list(); lF$penv<-penv; lF$TerminationEps<-parm(1.2);lF$Max<-parm(1.0)
    solution<-list(); solution$genotype<-list();  solution$genotype$fit<-0.5
    terminateRelativeErrorZero(solution, lF)
    solution<-list(); solution$genotype<-list();  solution$genotype$fit<-9.6
    terminateRelativeErrorZero(solution, lF)
}
\seealso{
Other Termination Condition: 
\code{\link{terminateAbsoluteError}()},
\code{\link{terminateGEQ}()},
\code{\link{terminateLEQ}()},
\code{\link{terminatePAC}()},
\code{\link{terminateRelativeError}()},
\code{\link{terminatedFalse}()}
}
\concept{Termination Condition}
