% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kemna_vorst_geometric.R
\name{price_kemna_vorst_geometric}
\alias{price_kemna_vorst_geometric}
\title{Kemna-Vorst Geometric Average Asian Option}
\usage{
price_kemna_vorst_geometric(S0, K, r, sigma, T0, T_mat, option_type = "call")
}
\arguments{
\item{S0}{Numeric. Initial stock price at time T0 (start of averaging period).
Must be positive.}

\item{K}{Numeric. Strike price. Must be positive.}

\item{r}{Numeric. Gross risk-free interest rate per period (e.g., 1.05 for 5%).
Must be positive.}

\item{sigma}{Numeric. Volatility (annualized standard deviation). Must be
non-negative.}

\item{T0}{Numeric. Start time of averaging period. Must be non-negative.}

\item{T_mat}{Numeric. Maturity time. Must be greater than T0.}

\item{option_type}{Character. Type of option: "call" (default) or "put".}
}
\value{
Numeric. The analytical price of the geometric average Asian option.
}
\description{
Calculates the price of a geometric average Asian call option using the
closed-form analytical solution from Kemna & Vorst (1990). This is the
standard benchmark implementation WITHOUT price impact.
}
\details{
The geometric average at maturity is defined as:
\deqn{G_T = \exp\left(\frac{1}{T-T_0} \int_{T_0}^{T} \log(S(\tau)) d\tau\right)}

For the discrete case with n+1 observations:
\deqn{G_T = \left(\prod_{i=0}^{n} S(T_i)\right)^{1/(n+1)}}

The closed-form solution for a call option is:
\deqn{C = S_0 e^{d^*} N(d) - K N(d - \sigma_G\sqrt{T-T_0})}

where:
\deqn{d^* = \frac{1}{2}(r - \frac{\sigma^2}{6})(T - T_0)}
\deqn{d = \frac{\log(S_0/K) + \frac{1}{2}(r + \frac{\sigma^2}{6})(T-T_0)}{\sigma\sqrt{(T-T_0)/3}}}

and \eqn{N(\cdot)} is the cumulative standard normal distribution function.
}
\examples{
price_kemna_vorst_geometric(
  S0 = 100, K = 100, r = 0.05, sigma = 0.2,
  T0 = 0, T_mat = 1, option_type = "call"
)

}
\references{
Kemna, A.G.Z. and Vorst, A.C.F. (1990). "A Pricing Method for Options Based
on Average Asset Values." \emph{Journal of Banking and Finance}, 14, 113-129.
}
