% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_prepare_data.R
\name{do_prepare_data}
\alias{do_prepare_data}
\title{Prepare ACB play-by-play data}
\usage{
do_prepare_data(data, day_num, data_gsl, data_ginfo, game_code_excel)
}
\arguments{
\item{data}{Source play-by-play data from a given game.}

\item{day_num}{Day number.}

\item{data_gsl}{Games' starting lineups.}

\item{data_ginfo}{Games' basic information.}

\item{game_code_excel}{Game code.}
}
\value{
Data frame. Each row represents the action happened in the game. It has
associated a player, a time point and the game score. The \strong{team} 
column refers to the team to which the player belongs.
}
\description{
Prepare the ACB play-by-play data to be analyzed in further steps. 
It involves correcting some inconsistencies and filtering some
unnecessary information.
}
\note{
1. Actions are given in Spanish. A bilingual basketball vocabulary (Spanish/English)
is provided in \url{https://www.uv.es/vivigui/docs/basketball_dictionary.xlsx}.

2. The \strong{game_code} column allows us to detect the source website, for example,
\url{https://live.acb.com/es/partidos/103389/jugadas}.
}
\examples{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

acb_games_2223_sl <- acb_vbc_cz_sl_2223 \%>\%
  filter(period == "1C")

df1 <- do_prepare_data(df0, day_num, 
                       acb_games_2223_sl, acb_games_2223_info,
                       game_code)
#df1                        

}
\author{
Guillermo Vinue
}
