% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_plot_monthly_stats.R
\name{get_plot_monthly_stats}
\alias{get_plot_monthly_stats}
\title{Monthly stats}
\usage{
get_plot_monthly_stats(df_stats, title, size_text = 2.5, type_plot, language, 
                       same_team = FALSE, hjust_val = 2, vjust_val = 0.5)
}
\arguments{
\item{df_stats}{Data frame with the statistics.}

\item{title}{Plot title.}

\item{size_text}{Label size for each bar. Default 2.5.}

\item{type_plot}{String, either 'bar_plot' or 'line_plot'.}

\item{language}{String, either 'English' or 'Spanish'. Needed for the line plot.}

\item{same_team}{Logical to specify if players selected belong to the same team.
If so, the facet labels in the line plot can be abbreviated.}

\item{hjust_val}{Adjust horizontally the text in the line plot.}

\item{vjust_val}{Adjust vertically the text in the line plot.}
}
\value{
Graphical device.
}
\description{
In all the available basketball websites, the stats are presented for the whole
number of games played. This function represents the players' stats 
for each month, which is very useful to analyze the players' evolution. The plot
can be either a bar plot or a line plot.
}
\examples{
\dontrun{
library(dplyr)

compet <- "ACB"

df <- do_join_games_bio(compet, acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)

months <- c(df \%>\% distinct(Month))$Month
months_order <- c("septiembre", "octubre", "noviembre", "diciembre", "enero")
months_plot <- match(months_order, months)
months_plot1 <- months_plot[!is.na(months_plot)]
months_plot2 <- months[months_plot1]

df3_m <- df1 \%>\%
filter(Team == "Real_Madrid", 
      Player.x == "Doncic, Luka") \%>\%
 group_by(Month) \%>\%
 do(do_stats(., "Average", "2017-2018", "ACB", "Regular Season")) \%>\%
 ungroup() \%>\%
 mutate(Month = factor(Month, levels = months_plot2)) \%>\%
 arrange(Month)

stats <- c("GP", "MP", "PTS", "FGA", "FGPerc", "ThreePA", 
           "ThreePPerc", "FTA", "FTPerc",
           "TRB", "ORB", "AST", "TOV", "STL")
           
df3_m1 <- df3_m \%>\%
  select(1:5, all_of(stats), 46:50) \%>\%
  mutate(Month = plyr::mapvalues(Month, 
                                 from = c("octubre", "noviembre", "diciembre", "enero"),
                                 to = c("October", "November", "December", "January")))
  
get_plot_monthly_stats(df3_m1, paste("ACB", "2017-2018", "Average", sep = " ; "), 
                       2.5, "bar_plot", "English")
                       
get_plot_monthly_stats(df3_m1, paste("ACB", "2017-2018", "Average", sep = " ; "), 
                       2.5, "line_plot", "English")
}

}
\seealso{
\code{\link{capit_two_words}}
}
\author{
Guillermo Vinue
}
