% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_possession_stats_lineup.R
\name{do_possession_stats_lineup}
\alias{do_possession_stats_lineup}
\title{Possessions-related statistics for lineups}
\usage{
do_possession_stats_lineup(data_combs, team_name, type_lineup, type_period, type_opponent, 
                           cols_group = c("team", "lineup"))
}
\arguments{
\item{data_combs}{Data frame with all the combinations of lineups.}

\item{team_name}{Name of the team.}

\item{type_lineup}{Type of lineups to analyze. Options are 'quintet', 'quartet', 'trio',
'duo' and 'single'.}

\item{type_period}{Period of interest. Options are xC, where x starts from 1. 
Common periods are from 1 to 4. Overtimes are labeled with the next numbers, such as 5C 
for the first overtime and 6C for the second one. Nothing to do if NULL.}

\item{type_opponent}{Name of the opponent teams. Nothing to do if NULL.}

\item{cols_group}{Group of columns to apply the computations. Default is c("team", "lineup")
to compute the metrics just for the players on court. To compute them for the players
both on and off court, use c("team", "lineup", "status").}
}
\value{
A data frame with the possessions statistics for each lineup.
}
\description{
Compute the possessions-related statistics for lineups. These statistics are
offensive rating, defensive rating, net rating, pace and number of possessions.
}
\details{
See \url{https://www.basketball-reference.com/about/glossary.html}
for formulas and explanations.
}
\examples{
\dontrun{
do_possession_stats_lineup(acb_combs, "Unicaja", "quintet", NULL, NULL)
}

}
\seealso{
\code{\link{do_possession_stats}}
}
\author{
Guillermo Vinue
}
