% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_latent.profiles.R
\name{ggplot_latent.profiles}
\alias{ggplot_latent.profiles}
\title{Plot Latent Factor Profiles by Cluster}
\usage{
ggplot_latent.profiles(
  Gibbs,
  burnin = NA,
  factor_labels = NULL,
  cluster_names = NULL,
  colors = NULL,
  title = "Latent Factor Profiles by Cluster",
  x_label = "Factor",
  y_label = "Posterior Mean"
)
}
\arguments{
\item{Gibbs}{Gibbs sample derived from \code{BCFM} function}

\item{burnin}{Number of burn-in period. If not specified, it uses the first tenth as burn-in period}

\item{factor_labels}{Character vector of factor names. If NULL, defaults to Factor 1, Factor 2, etc.}

\item{cluster_names}{Character vector of cluster names. If NULL, defaults to Cluster 1, Cluster 2, etc.}

\item{colors}{Named vector of colors for each cluster. If NULL, uses default color palette}

\item{title}{Plot title. Default is "Latent Factor Profiles by Cluster"}

\item{x_label}{X-axis label. Default is "Factor"}

\item{y_label}{Y-axis label. Default is "Posterior Mean"}
}
\value{
A ggplot object
}
\description{
Visualizes the latent factor profile means (mu) for each cluster, similar to Latent Profile Analysis (LPA) plots
}
\examples{
\donttest{
# Fit a model first using the included simulated dataset
data(sim.data)
data.pre <- init.data(sim.data, paste0("V", 1:5))
model.attributes <- initialize.model.attributes(S = nrow(sim.data), times = 1,
                                                 R = 5, L = 2, G = 2)
cluster.hyperparms <- initialize.cluster.hyperparms(data.pre, model.attributes)
hyp.parm <- initialize.hyp.parm(model.attributes, cluster.hyperparms)
result <- BCFM.fit(data.pre, model.attributes, hyp.parm,
                   n.iter = 100, every = 10)

# Plot latent profiles
ggplot_latent.profiles(Gibbs = result$Result)
}
}
